import sys
from collections import defaultdict

def main():
    podaci = sys.stdin.read().strip().split()
    if not podaci:
        return
    it = iter(podaci)
    n = int(next(it))
    xs = [0]*n
    ys = [0]*n
    for i in range(n):
        xs[i] = int(next(it))
        ys[i] = int(next(it))

    broj_po_u = defaultdict(int)
    broj_po_v = defaultdict(int)
    po_y = defaultdict(lambda: [0,0])
    po_x = defaultdict(lambda: [0,0])

    for x, y in zip(xs, ys):
        broj_po_u[x - y] += 1
        broj_po_v[x + y] += 1
        po_y[y][x & 1] += 1
        po_x[x][y & 1] += 1

    def parovi(m: int) -> int:
        return (m*(m-1)) // 2

    rezultat = 0
    for m in broj_po_u.values():
        if m > 1:
            rezultat += 2 * parovi(m)
    for m in broj_po_v.values():
        if m > 1:
            rezultat += 2 * parovi(m)
    for parnost0, parnost1 in po_y.values():
        if parnost0 > 1:
            rezultat += parovi(parnost0)
        if parnost1 > 1:
            rezultat += parovi(parnost1)
    for parnost0, parnost1 in po_x.values():
        if parnost0 > 1:
            rezultat += parovi(parnost0)
        if parnost1 > 1:
            rezultat += parovi(parnost1)

    print(rezultat)

if __name__ == '__main__':
    main()